/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.mixer;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinInventory;
import com.zurrtum.create.content.processing.basin.BasinOperatingBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.foundation.recipe.TimedRecipe;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.particle.FluidParticleData;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_8786;

public class MechanicalMixerBlockEntity
extends BasinOperatingBlockEntity {
    private static final Object shapelessOrMixingRecipesKey = new Object();
    public int runningTicks;
    public int processingTicks;
    public boolean running;

    public MechanicalMixerBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.MECHANICAL_MIXER, pos, state);
    }

    public float getRenderedHeadOffset(float partialTicks) {
        float offset = 0.0f;
        if (this.running) {
            if (this.runningTicks < 20) {
                int localTick = this.runningTicks;
                float num = ((float)localTick + partialTicks) / 20.0f;
                num = (2.0f - class_3532.method_15362((double)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            } else if (this.runningTicks <= 20) {
                offset = 1.0f;
            } else {
                int localTick = 40 - this.runningTicks;
                float num = ((float)localTick - partialTicks) / 20.0f;
                num = (2.0f - class_3532.method_15362((double)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            }
        }
        return offset + 0.4375f;
    }

    public float getRenderedHeadRotationSpeed(float partialTicks) {
        float speed = this.getSpeed();
        if (this.running) {
            if (this.runningTicks < 15) {
                return speed;
            }
            if (this.runningTicks <= 20) {
                return speed * 2.0f;
            }
            return speed;
        }
        return speed / 2.0f;
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.MIXER);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867).method_1012(0.0, -1.5, 0.0);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        this.running = view.method_71433("Running", false);
        this.runningTicks = view.method_71424("Ticks", 0);
        super.read(view, clientPacket);
        if (clientPacket && this.method_11002()) {
            this.getBasin().ifPresent(bte -> bte.setAreFluidsMoving(this.running && this.runningTicks <= 20));
        }
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        view.method_71472("Running", this.running);
        view.method_71465("Ticks", this.runningTicks);
        super.write(view, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.runningTicks >= 40) {
            this.running = false;
            this.runningTicks = 0;
            this.basinChecker.scheduleUpdate();
            return;
        }
        float speed = Math.abs(this.getSpeed());
        if (this.running && this.field_11863 != null) {
            if (this.field_11863.method_8608() && this.runningTicks == 20) {
                this.renderParticles();
            }
            if (this.getSpeed() == 0.0f || !this.isSpeedRequirementFulfilled()) {
                if (this.runningTicks < 20) {
                    this.runningTicks = 40 - this.runningTicks;
                } else if (this.runningTicks == 20) {
                    ++this.runningTicks;
                }
            }
            if ((!this.field_11863.method_8608() || this.isVirtual()) && this.runningTicks == 20) {
                if (this.processingTicks < 0) {
                    float f;
                    class_1860 class_18602 = this.currentRecipe;
                    if (class_18602 instanceof TimedRecipe) {
                        TimedRecipe recipe = (TimedRecipe)class_18602;
                        f = (float)recipe.time() * 0.15f;
                    } else {
                        f = 15.0f;
                    }
                    float recipeSpeed = f;
                    this.processingTicks = class_3532.method_15340((int)(class_3532.method_15351((int)((int)(512.0f / speed))) * class_3532.method_15386((float)recipeSpeed) + 1), (int)1, (int)512);
                    this.getBasin().ifPresent(basin -> {
                        Couple<SmartFluidTankBehaviour> tanks = basin.getTanks();
                        if (!((SmartFluidTankBehaviour)tanks.getFirst()).isEmpty() || !((SmartFluidTankBehaviour)tanks.getSecond()).isEmpty()) {
                            this.field_11863.method_8396(null, this.field_11867, class_3417.field_14650, class_3419.field_15245, 0.75f, speed < 65.0f ? 0.75f : 1.5f);
                        }
                    });
                } else {
                    --this.processingTicks;
                    if (this.processingTicks == 0) {
                        ++this.runningTicks;
                        this.processingTicks = -1;
                        this.applyBasinRecipe();
                        this.sendData();
                    }
                }
            }
            if (this.runningTicks != 20) {
                ++this.runningTicks;
            }
        }
    }

    public void renderParticles() {
        Optional<BasinBlockEntity> basin = this.getBasin();
        if (basin.isEmpty() || this.field_11863 == null) {
            return;
        }
        BasinInventory inv = basin.get().itemCapability;
        int size = inv.method_5439();
        for (int slot = 0; slot < size; ++slot) {
            class_1799 stackInSlot = inv.method_5438(slot);
            if (stackInSlot.method_7960()) continue;
            class_2392 data = new class_2392(class_2398.field_11218, stackInSlot);
            this.spillParticle((class_2394)data);
        }
        for (SmartFluidTankBehaviour behaviour : basin.get().getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                FluidStack stack = tankSegment.getRenderedFluid();
                this.spillParticle(new FluidParticleData(AllParticleTypes.FLUID_PARTICLE, stack.getFluid(), stack.getComponentChanges()));
            }
        }
    }

    protected void spillParticle(class_2394 data) {
        float angle = this.field_11863.field_9229.method_43057() * 360.0f;
        class_243 offset = new class_243(0.0, 0.0, 0.25);
        offset = VecHelper.rotate(offset, angle, class_2350.class_2351.field_11052);
        class_243 target = VecHelper.rotate(offset, this.getSpeed() > 0.0f ? 25.0 : -25.0, class_2350.class_2351.field_11052).method_1031(0.0, 0.25, 0.0);
        class_243 center = offset.method_1019(VecHelper.getCenterOf((class_2382)this.field_11867));
        target = VecHelper.offsetRandomly(target.method_1020(offset), this.field_11863.field_9229, 0.0078125f);
        this.field_11863.method_8406(data, center.field_1352, center.field_1351 - 1.75, center.field_1350, target.field_1352, target.field_1351, target.field_1350);
    }

    @Override
    protected boolean matchStaticFilters(class_8786<? extends class_1860<?>> recipe) {
        class_3956 type;
        class_1860 r = recipe.comp_1933();
        if (r instanceof class_1867) {
            class_1867 shapelessRecipe = (class_1867)r;
            if (((Boolean)AllConfigs.server().recipes.allowShapelessInMixer.get()).booleanValue() && shapelessRecipe.field_9047.size() > 1 && !MechanicalPressBlockEntity.canCompress(r) && !AllRecipeTypes.shouldIgnoreInAutomation(recipe)) {
                return true;
            }
        }
        if ((type = r.method_17716()) == AllRecipeTypes.POTION && ((Boolean)AllConfigs.server().recipes.allowBrewingInMixer.get()).booleanValue()) {
            return true;
        }
        return type == AllRecipeTypes.MIXING;
    }

    @Override
    public void startProcessingBasin() {
        if (this.running && this.runningTicks <= 20) {
            return;
        }
        super.startProcessingBasin();
        this.running = true;
        this.runningTicks = 0;
    }

    @Override
    public boolean continueWithPreviousRecipe() {
        this.runningTicks = 20;
        return true;
    }

    @Override
    protected void onBasinRemoved() {
        if (!this.running) {
            return;
        }
        this.runningTicks = 40;
        this.running = false;
    }

    @Override
    protected Object getRecipeCacheKey() {
        return shapelessOrMixingRecipesKey;
    }

    @Override
    protected boolean isRunning() {
        return this.running;
    }

    @Override
    protected Optional<CreateTrigger> getProcessedRecipeTrigger() {
        return Optional.of(AllAdvancements.MIXER);
    }
}

